/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.ChangeConsoleIntCodeConstants;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateLevel;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SpecifyIntCodeChgsBean
extends PanelBean
implements ChangeConsoleIntCodeConstants,
UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCLSPBT";
    private static final String TRACE_MASKF = "XMCLSPBF";
    private static final String TRACE_MASKD = "XMCLSPBD";
    private List m_idECChgTable = null;
    private ColumnDescriptor[] m_cdECChgTableStructure = null;
    private int[] m_iECChgTableSelection;
    private static final int NUM_COLUMNS = 2;
    private static final int NUM_ROWS = 20;
    private static final String TABLE_NAME = "ECChgTable";
    private static FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "SpecifyIntCodeChgsBean");

    public SpecifyIntCodeChgsBean() {
        this.setBeanName("SpecifyIntCodeChgsPanel");
    }

    public ColumnDescriptor[] getECChgTableRowStructure() {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.getECChgTableRowStructure()");
        return this.m_cdECChgTableStructure;
    }

    public int getECChgTableRowStatus() {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.getECChgTableRowStatus()");
        return 3;
    }

    public int getECChgTableRowCount() {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.getECChgTableRowCount()");
        return 20;
    }

    public ItemDescriptor[] getECChgTableRowAt(int index) {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.getECChgTableRowAt(), index: " + index);
        String[] stringArrayRow = (String[])this.m_idECChgTable.get(index);
        ItemDescriptor[] rowData = new ItemDescriptor[2];
        rowData[0] = new ItemDescriptor("EngChg1PCol" + index, stringArrayRow[0]);
        String outLevel = stringArrayRow[1];
        int levelLength = outLevel.length();
        if (levelLength > 0 && levelLength < 3) {
            outLevel = "000".substring(0, 3 - levelLength) + outLevel;
        }
        rowData[1] = new ItemDescriptor("ChgLevel1Col" + index, outLevel);
        return rowData;
    }

    public void setECChgTableRowAt(int index, ItemDescriptor[] items) {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.setECChgTableRowAt(), index: " + index);
        String[] stringArrayRow = new String[2];
        for (int i = 0; i < 2; ++i) {
            Trace.trace(TRACE_MASKD, "[setECChgTableRowAt()] item #" + i + ": " + items[i]);
            stringArrayRow[i] = items[i].getTitle().trim().toUpperCase();
        }
        this.m_idECChgTable.set(index, stringArrayRow);
    }

    public int[] getECChgTableSelection() {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.getECChgTableSelection()");
        return this.m_iECChgTableSelection;
    }

    public void setECChgTableSelection(int[] selected) {
        Trace.trace(TRACE_MASKD, "<> SpecifyIntCodeChgsBean.setECChgTableSelection()");
        for (int i = 0; i < selected.length; ++i) {
            Trace.trace(TRACE_MASKD, "[setECChgTableSelection()] selected row #" + i + ": " + selected[i]);
        }
        this.m_iECChgTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "<> SpecifyIntCodeChgsBean.load()");
        if (null == this.m_idECChgTable) {
            this.m_idECChgTable = new ArrayList(20);
            for (int i = 0; i < 20; ++i) {
                this.m_idECChgTable.add(new String[]{"", ""});
            }
        }
        this.setECChgTableSelection(new int[0]);
    }

    public void initializeWithServerData(List data) {
        int numPersistRows;
        Trace.trace(TRACE_MASKT, "-> SpecifyIntCodeChgsBean.initializeWithServerData()");
        this.m_idECChgTable = new ArrayList(20);
        if (null != data) {
            Iterator rowIterator = data.iterator();
            while (rowIterator.hasNext()) {
                UpdateLevel rowData = (UpdateLevel)rowIterator.next();
                String ecNumber = rowData.getUpdateableComponentECNumber();
                int intLevel = rowData.getLevel();
                if (intLevel == -1) {
                    this.m_idECChgTable.add(new String[]{ecNumber, "ALL"});
                    continue;
                }
                this.m_idECChgTable.add(new String[]{ecNumber, Integer.toString(intLevel)});
            }
            numPersistRows = data.size();
        } else {
            numPersistRows = 0;
            Trace.trace(TRACE_MASKD, "[initializeWithServerData()] The List object passed in is NULL.");
        }
        Trace.trace(TRACE_MASKD, "[load()] The number of rows filled with persisted data: " + numPersistRows);
        for (int i = numPersistRows; i < 20; ++i) {
            this.m_idECChgTable.add(new String[]{"", ""});
        }
        Trace.trace(TRACE_MASKT, "<- SpecifyIntCodeChgsBean.initializeWithServerData()");
    }

    private void clearTable() {
        Trace.trace(TRACE_MASKT, "<> SpecifyIntCodeChgsBean.clearTable()");
        Collections.fill(this.m_idECChgTable, new String[]{"", ""});
        this.setECChgTableSelection(new int[0]);
        this.getUserTaskManager().refreshElement(TABLE_NAME);
    }

    private void removeEmptyTableRowsBeforeData() {
        Trace.trace(TRACE_MASKT, "<> SpecifyIntCodeChgsBean.removeEmptyTableRowsBeforeData()");
        Iterator rowIterator = this.m_idECChgTable.iterator();
        while (rowIterator.hasNext()) {
            String[] rowData = (String[])rowIterator.next();
            String ecNumber = rowData[0];
            String level = rowData[1];
            if (ecNumber.length() != 0 || level.length() != 0) continue;
            rowIterator.remove();
        }
        for (int i = this.m_idECChgTable.size(); i < 20; ++i) {
            this.m_idECChgTable.add(i, new String[]{"", ""});
        }
        this.setECChgTableSelection(new int[0]);
        this.getUserTaskManager().refreshElement(TABLE_NAME);
    }

    private String findDuplicateECNumber() {
        Trace.trace(TRACE_MASKT, "<> SpecifyIntCodeChgsBean.isDuplicateECNumber()");
        String duplicate = null;
        HashSet<String> hs = new HashSet<String>(20);
        Iterator rowIterator = this.m_idECChgTable.iterator();
        while (rowIterator.hasNext()) {
            String[] rowData = (String[])rowIterator.next();
            String ecNumber = rowData[0];
            if (ecNumber.length() == 0) continue;
            if (hs.contains(ecNumber)) {
                duplicate = ecNumber;
                break;
            }
            hs.add(ecNumber);
        }
        return duplicate;
    }

    private void showMessage(String titleKey, String messageKey) {
        Trace.trace(TRACE_MASKT, "<> SpecifyIntCodeChgsBean.showMessage");
        try {
            CommonMsgApp.showMessageBox(this.getUserTaskManager(), new BaseMessageTitle(titleKey), new BaseMessageText(messageKey));
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "[showMessage] Exception working with message box: ", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void panelAction(TaskActionEvent event) {
        block21: {
            Trace.trace(TRACE_MASKT, "-> SpecifyIntCodeChgsBean.panelAction()");
            boolean gotError = false;
            try {
                String command = event.getActionCommand();
                Trace.trace(TRACE_MASKF, "[panelAction()] action command: '" + command + "'.");
                if (command.equalsIgnoreCase("CANCEL")) {
                    Trace.trace(TRACE_MASKD, "[panelAction()] CANCEL action command was received.");
                    this.dispose();
                    break block21;
                }
                if (command.equalsIgnoreCase("OKButton")) {
                    this.getUserTaskManager().storeAllElements();
                    this.removeEmptyTableRowsBeforeData();
                    ArrayList<void> ulList = new ArrayList<void>();
                    Iterator rowIterator = this.m_idECChgTable.iterator();
                    while (rowIterator.hasNext()) {
                        void var9_11;
                        UpdateLevel ul;
                        String[] rowData = (String[])rowIterator.next();
                        String ecNumber = rowData[0];
                        String level = rowData[1];
                        Trace.trace(TRACE_MASKD, "[panelAction()] EC number: '" + ecNumber + "', level: '" + level + "'");
                        if (ecNumber.length() == 0) {
                            if (level.length() == 0) break;
                            this.showMessage("MCL8027", "MCL0028");
                            gotError = true;
                            break;
                        }
                        if (level.length() == 0) {
                            this.showMessage("MCL8027", "MCL0030");
                            gotError = true;
                            break;
                        }
                        if (level.equalsIgnoreCase("ALL")) {
                            ul = new UpdateLevel(ecNumber, -1);
                        } else {
                            try {
                                int intLevel = Integer.parseInt(level);
                                if (intLevel == 0) {
                                    this.showMessage("MCL8027", "MCL0030");
                                    gotError = true;
                                    break;
                                }
                                ul = new UpdateLevel(ecNumber, intLevel);
                            }
                            catch (NumberFormatException nfe) {
                                this.showMessage("MCL8027", "MCL0033");
                                gotError = true;
                                break;
                            }
                        }
                        ulList.add(var9_11);
                    }
                    if (!gotError) {
                        if (ulList.isEmpty()) {
                            this.showMessage("MCL8032", "MCL0032");
                        } else {
                            String duplicate = this.findDuplicateECNumber();
                            if (null != duplicate) {
                                try {
                                    CommonMsgApp.showMessageBox(this.getUserTaskManager(), new BaseMessageTitle("MCL8027"), new BaseMessageText("MCL0031", new String[]{duplicate}));
                                }
                                catch (HException e) {
                                    Trace.trace(TRACE_MASKF, "[panelAction()] Exception working with message box: ", e);
                                }
                            } else {
                                PanelTaskletRequest request = new PanelTaskletRequest();
                                request.setData("event", event);
                                request.setData("userData", ulList);
                                this.postTaskletRequest(request);
                            }
                        }
                    }
                    break block21;
                }
                if (command.equalsIgnoreCase("ClearButton")) {
                    this.clearTable();
                } else {
                    Trace.trace(TRACE_MASKF, "[panelAction()] Ignore the unexpected action command.");
                }
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "[panelAction()] exception: " + e);
                new FrameworkLog(classLogInfo, -4350, e).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- SpecifyIntCodeChgsBean.panelAction()");
    }
}

